<?php
/* --------------------------------------------------------------
   CounterApplicationBottomExtender.inc.php 2022-02-15 gm
   Gambio GmbH
   http://www.gambio.de
   Copyright (c) 2022 Gambio GmbH
   Released under the GNU General Public License (Version 2)
   [http://www.gnu.org/licenses/gpl-2.0.html]
   --------------------------------------------------------------
*/

class CounterApplicationBottomExtender extends CounterApplicationBottomExtender_parent
{
    public function proceed()
    {
        if ($this->isMonitoringRequest()) {
            
            parent::proceed();
        }
        
        // -> create new counter obj if not exist
        if (empty($_SESSION['gm_tracking'])) {
            $gm_tracking = new GMC();
            
            $_SESSION['gm_tracking'] = $gm_tracking;
            
            //	-> set once a time ip, browser and platform of the current user
            $this->v_output_buffer['SCRIPT_COUNTER'] = $_SESSION['gm_tracking']->gmc_set_current_user(false);
        }
        
        $_SESSION['gm_tracking']->gmc_record($this->v_data_array['products_id'], $this->v_data_array['cPath']);
        $_SESSION['gm_tracking']->gmc_delete_old_ip();
        
        parent::proceed();
    }
    
    
    /**
     * @return bool
     */
    protected function isMonitoringRequest(): bool
    {
        return isset($_SERVER['HTTP_X_REQUEST_BY']) && strtolower($_SERVER['HTTP_X_REQUEST_BY']) === 'monitoring';
    }
}
